//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include <jpeg.hpp>
#include "Process.h"
#include "MainUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::OpenBtnClick(TObject *Sender)
{
    if (OpenDialog->Execute()) {
        // Load Image From File
        Image1->Picture->Bitmap->LoadFromFile(OpenDialog->FileName);

        // Turn Bitmap Into RGB 3-Chanel Pixel Values
        Pixels = BitmapToPixels(Image1->Picture->Bitmap, &W, &H);

        // Adjust Form Size To Show Image
        MainForm->ClientHeight  = H+2*Image1->Left + BottomPanel->Height;
        MainForm->ClientWidth = W+2*Image1->Left;

        // Enable Processing Buttons
        ProcessBtn->Enabled = true;
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ProcessBtnClick(TObject *Sender)
{
    // Image Processing ( RGB -> Y(Gray-Level) )
    for (int i=0; i<H; i++) {
        for (int j=0; j<W; j++) {
            double y = 0.299*static_cast<double>(Pixels[(i*W+j)*3]) +
                       0.587*static_cast<double>(Pixels[(i*W+j)*3+1]) +
                       0.114*static_cast<double>(Pixels[(i*W+j)*3+2]);
            y = static_cast<unsigned char>(y);
            // y = ((y<0)? 0 : (y>255)? 255 : y);
            Pixels[(i*W+j)*3] = Pixels[(i*W+j)*3+1] = Pixels[(i*W+j)*3+2] = y;
        }
    }

    // Adjust Form Size To Show Image
    Image2->Top = Image1->Top;
    Image2->Left = W+2*Image1->Left;
    MainForm->ClientHeight  = H+2*Image1->Left + BottomPanel->Height;
    MainForm->ClientWidth   = 2*W+3*Image1->Left;

    // Show Generated Image
    PixelsToBitmap(Image2->Picture->Bitmap, Pixels, W, H);

    // Enable Processing Buttons
    SaveBtn->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SaveBtnClick(TObject *Sender)
{
    if (SaveDialog->Execute()) {
        Image2->Picture->Bitmap->SaveToFile(SaveDialog->FileName);
    }
}
//---------------------------------------------------------------------------
