// ReadBMPView.cpp : implementation of the CReadBMPView class
//

#include "stdafx.h"
#include "ReadBMP.h"

#include "ReadBMPDoc.h"
#include "ReadBMPView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CReadBMPView

IMPLEMENT_DYNCREATE(CReadBMPView, CView)

BEGIN_MESSAGE_MAP(CReadBMPView, CView)
	//{{AFX_MSG_MAP(CReadBMPView)
	ON_COMMAND(ID_CV_GRAY, OnCvGray)
	ON_COMMAND(ID_CV_SOBEL, OnCvSobel)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CReadBMPView construction/destruction

CReadBMPView::CReadBMPView()
{
	// TODO: add construction code here

}

CReadBMPView::~CReadBMPView()
{
}

BOOL CReadBMPView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CReadBMPView drawing

void CReadBMPView::OnDraw(CDC* pDC)
{
	CReadBMPDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
	if(pDoc->m_dib!=NULL)
	{
		CRect rect(CPoint(0,0),pDoc->m_dib->GetDimensions());
		pDoc->m_dib->Draw(pDC,rect);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CReadBMPView printing

BOOL CReadBMPView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CReadBMPView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CReadBMPView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CReadBMPView diagnostics

#ifdef _DEBUG
void CReadBMPView::AssertValid() const
{
	CView::AssertValid();
}

void CReadBMPView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CReadBMPDoc* CReadBMPView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CReadBMPDoc)));
	return (CReadBMPDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CReadBMPView message handlers

void CReadBMPView::OnCvGray() 
{
	CReadBMPDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc->m_dib)  return;

	pDoc->m_dib->UpdateGrayPixels();
	Invalidate();
}

void CReadBMPView::OnCvSobel() 
{
	// For [CS6550]Computer Vision Students:
	// Please Add Your Code Here!!

	// Example
	CReadBMPDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	CDib *dib = pDoc->m_dib;
	if (!dib)  return;

	int h = dib->m_lpBMIH->biHeight;
	int w = dib->m_lpBMIH->biWidth;

	for (int i=0; i<h; i++) {
		for (int j=0; j<w; j++) {
			if (i<5 || j<5 || i>=h-5 || j>=w-5)  dib->SetGrayPixel(j,i,0.0);
		}
	}

	dib->UpdateGrayPixels();
	Invalidate();
}
