#ifndef ProcessH
#define ProcessH

#include <graphics.hpp>         // C++ Builder header

#ifndef BYTE
typedef unsigned char BYTE;
#endif

BYTE* BitmapToPixels(Graphics::TBitmap* bmp, long* width, long* height);
Graphics::TBitmap* PixelsToBitmap(Graphics::TBitmap* bmp, BYTE* pixels, int w, int h);

inline BYTE* BitmapToPixels(Graphics::TBitmap* bmp, long* width, long* height)
{
    Graphics::TBitmap* bmp2 = NULL;
    BYTE *pixels = NULL;
    int i, j;
    int w, h, len;
    BYTE *p1, *p2;

    if (bmp->PixelFormat!=pf24bit) {
        bmp2 = new Graphics::TBitmap;
        bmp2->Assign(bmp);
        bmp2->PixelFormat = pf24bit;
        bmp = bmp2;
    }

    w = bmp->Width;
    h = bmp->Height;
    len = w*3;

    if (width!=NULL) *width = w;
    if (height!=NULL) *height = h;
    if (pixels==NULL) pixels = new BYTE[h*len];

    for (i=0; i<h; i++) {
        p1 = pixels+i*len;
        p2 = (BYTE*)bmp->ScanLine[i];
        for (j=0; j<w; j++, p1+=3, p2+=3) {
            *(p1+0) = *(p2+2);
            *(p1+1) = *(p2+1);
            *(p1+2) = *(p2+0);
        }
    }

    if (bmp2!=NULL) {
        delete bmp2;
    }

    return pixels;
}

inline Graphics::TBitmap* PixelsToBitmap(Graphics::TBitmap* bmp, BYTE* pixels, int w, int h)
{
    int i, j;
    int len;
    BYTE *p1, *p2;

    if (bmp==NULL) bmp = new Graphics::TBitmap;

    bmp->PixelFormat=pf24bit;
    bmp->Width = w;
    bmp->Height = h;

    len = w*3;
    for (i=0; i<h; i++) {
        p1 = (BYTE*)bmp->ScanLine[i];
        //p2 = pixels+(h-i-1)*len;
        p2 = pixels+(i)*len;
        for (j=0; j<w; j++, p1+=3, p2+=3) {
            *(p1+0) = *(p2+2);
            *(p1+1) = *(p2+1);
            *(p1+2) = *(p2+0);
        }
    }

    return bmp;
}
#endif
